/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.steps;

import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWStepDefinition;
import filenet.vw.api.VWStepProcessorInfoDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.canvas.process.VWPropertyMenuItem;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.steps.IVWGeneralStepPropertyTabs;
import filenet.vw.toolkit.design.property.steps.IVWPropertyTab;
import filenet.vw.toolkit.design.property.steps.VWSelectParametersPanel;
import filenet.vw.toolkit.design.property.steps.VWStepProcessorRegistrationDialog;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeSource;
import filenet.vw.toolkit.utils.table.VWSeparatorListCellRenderer;
import filenet.vw.toolkit.utils.uicontrols.border.VWTitledBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class VWLaunchStepGeneralTab
extends JPanel
implements IVWGeneralStepPropertyTabs,
IVWPropertyTab,
DocumentListener,
ActionListener,
IVWPropertyChangeSource {
    protected VWStepDefinition m_stepDefinition = null;
    protected VWAuthPropertyData m_authPropertyData = null;
    protected VWStepProcessorRegistrationDialog m_stepProcessorRegistrationDialog = null;
    protected Vector m_changedItems = null;
    protected JTextField m_nameTextField = null;
    protected VWSelectParametersPanel m_selectParametersPanel = null;
    protected JComboBox m_stepProcessorComboBox = null;
    protected VWStepProcessorInfoDefinition[] m_stepProcessors = null;
    protected VWStepProcessorInfoDefinition m_defaultStepProcessor = null;
    protected JTextArea m_instructionsTextArea = null;

    public void setStepProcessors(VWStepProcessorInfoDefinition[] availableStepProcessors, VWStepProcessorInfoDefinition defaultStepProcessor) {
        this.m_stepProcessors = availableStepProcessors;
        this.m_defaultStepProcessor = defaultStepProcessor;
        if (this.m_stepProcessorComboBox != null) {
            this.updateStepProcessorComboBox(this.m_defaultStepProcessor, this.m_stepProcessors);
        }
    }

    public void init(VWAuthPropertyData authPropertyData, VWMapNode vwMapNode) {
        try {
            this.m_authPropertyData = authPropertyData;
            if (vwMapNode instanceof VWStepDefinition) {
                this.m_stepDefinition = (VWStepDefinition)vwMapNode;
            }
            this.createControls();
            this.setSelectedStep(vwMapNode);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedStep(VWMapNode vwMapNode) {
        this.m_stepDefinition = (VWStepDefinition)vwMapNode;
        try {
            this.m_nameTextField.getDocument().removeDocumentListener(this);
            this.m_instructionsTextArea.getDocument().removeDocumentListener(this);
            this.m_nameTextField.setText("");
            this.m_instructionsTextArea.setText("");
            if (this.m_stepDefinition != null) {
                this.m_nameTextField.setText(this.m_stepDefinition.getName());
                this.m_selectParametersPanel.setSelectedStep(this.m_stepDefinition);
                if (this.m_defaultStepProcessor != null) {
                    this.updateStepProcessorComboBox(this.m_defaultStepProcessor, this.m_stepProcessors);
                }
                this.m_instructionsTextArea.setText(this.m_stepDefinition.getDescription());
            } else {
                this.m_selectParametersPanel.reinitialize();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        finally {
            this.m_nameTextField.getDocument().addDocumentListener(this);
            this.m_instructionsTextArea.getDocument().addDocumentListener(this);
        }
    }

    public void releaseReferences() {
        if (this.m_nameTextField != null) {
            this.m_nameTextField.getDocument().removeDocumentListener(this);
            this.m_nameTextField.removeAll();
            this.m_nameTextField = null;
        }
        if (this.m_selectParametersPanel != null) {
            this.m_selectParametersPanel.releaseReferences();
            this.m_selectParametersPanel = null;
        }
        if (this.m_stepProcessorComboBox != null) {
            this.m_stepProcessorComboBox.removeActionListener(this);
            this.m_stepProcessorComboBox.removeAllItems();
            this.m_stepProcessorComboBox = null;
        }
        if (this.m_instructionsTextArea != null) {
            this.m_instructionsTextArea.getDocument().removeDocumentListener(this);
            this.m_instructionsTextArea.removeAll();
            this.m_instructionsTextArea = null;
        }
        this.m_stepProcessors = null;
        this.m_defaultStepProcessor = null;
        this.m_stepDefinition = null;
        this.m_authPropertyData = null;
        this.removeAll();
    }

    public void changedUpdate(DocumentEvent event) {
    }

    public void insertUpdate(DocumentEvent event) {
        this.handleDocumentEvent(event);
    }

    public void removeUpdate(DocumentEvent event) {
        this.handleDocumentEvent(event);
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getSource().equals(this.m_stepProcessorComboBox)) {
                this.onStepProcessorComboBox();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void notifyPropertyChange() {
        this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 501);
    }

    public Vector getItemsChanged() {
        return this.m_changedItems;
    }

    protected void createControls() {
        try {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.anchor = 23;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 0;
            gbCons.insets = new Insets(5, 5, 1, 10);
            this.add((Component)this.getNamePanel(), gbCons);
            ++gbCons.gridy;
            gbCons.fill = 1;
            gbCons.weighty = 1.0;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 0;
            gbCons.insets = new Insets(1, 5, 1, 20);
            this.m_selectParametersPanel = new VWSelectParametersPanel(this.m_authPropertyData);
            this.add((Component)this.m_selectParametersPanel, gbCons);
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 0.1;
            gbCons.weighty = 0.0;
            gbCons.gridheight = 1;
            gbCons.insets = new Insets(1, 5, 1, 10);
            this.add((Component)this.getStepProcessorPanel(), gbCons);
            ++gbCons.gridy;
            gbCons.fill = 1;
            gbCons.weighty = 1.0;
            this.add((Component)this.getInstructionsPanel(), gbCons);
            ComponentOrientation compOrientation = ComponentOrientation.getOrientation(Locale.getDefault());
            this.applyComponentOrientation(compOrientation);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected JPanel getNamePanel() {
        JPanel namePanel = new JPanel(new BorderLayout());
        try {
            namePanel.setBorder(new VWTitledBorder(VWResource.s_stepNameStr));
            this.m_nameTextField = new JTextField("", 20);
            this.m_nameTextField.getDocument().addDocumentListener(this);
            namePanel.add((Component)this.m_nameTextField, "First");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return namePanel;
    }

    protected JPanel getStepProcessorPanel() {
        JPanel stepProcessorPanel = new JPanel(new BorderLayout());
        try {
            stepProcessorPanel.setBorder(new VWTitledBorder(VWResource.s_stepProcessor));
            this.m_stepProcessorComboBox = new JComboBox();
            this.m_stepProcessorComboBox.setName("m_stepProcessorComboBox_VWLaunchStepGeneralTab");
            this.m_stepProcessorComboBox.setRenderer(new VWSeparatorListCellRenderer());
            this.m_stepProcessorComboBox.addActionListener(this);
            stepProcessorPanel.add((Component)this.m_stepProcessorComboBox, "First");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return stepProcessorPanel;
    }

    protected JPanel getInstructionsPanel() {
        JPanel instructionPanel = new JPanel(new BorderLayout());
        try {
            instructionPanel.setBorder(new VWTitledBorder(VWResource.s_instructionsInUserInterface));
            this.m_instructionsTextArea = new JTextArea();
            this.m_instructionsTextArea.setName("m_instructionTextArea_VWLaunchStepGeneralTab");
            this.m_instructionsTextArea.setLineWrap(true);
            this.m_instructionsTextArea.setWrapStyleWord(true);
            this.m_instructionsTextArea.setRows(5);
            this.m_instructionsTextArea.getDocument().addDocumentListener(this);
            instructionPanel.add((Component)new JScrollPane(this.m_instructionsTextArea), "Center");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return instructionPanel;
    }

    /*
     * Unable to fully structure code
     */
    protected void updateStepProcessorComboBox(VWStepProcessorInfoDefinition defaultStepProcessor, VWStepProcessorInfoDefinition[] stepProcessors) {
        try {
            if (this.m_stepDefinition == null) {
                return;
            }
            this.m_stepProcessorComboBox.removeActionListener(this);
            this.m_stepProcessorComboBox.removeAllItems();
            currentId = this.m_stepDefinition.getRequestedInterface();
            if (currentId != null) {
                try {
                    nCurrentId = Integer.parseInt(currentId);
                    if (stepProcessors == null) ** GOTO lbl22
                    for (i = 0; i < stepProcessors.length; ++i) {
                        if (stepProcessors[i].getId() != nCurrentId) continue;
                        currentId = stepProcessors[i].getName();
                        this.m_stepDefinition.setRequestedInterface(currentId);
                    }
                }
                catch (NumberFormatException ex) {}
            } else if (currentId == null && defaultStepProcessor != null) {
                currentId = defaultStepProcessor.getName();
                this.m_stepDefinition.setRequestedInterface(currentId);
            }
lbl22:
            // 7 sources

            if (stepProcessors != null) {
                bFound = false;
                for (i = 0; i < stepProcessors.length; ++i) {
                    stepProcessorName = stepProcessors[i].getName();
                    this.m_stepProcessorComboBox.addItem(stepProcessorName);
                    if (VWStringUtils.compare(stepProcessorName, currentId) != 0) continue;
                    this.m_stepProcessorComboBox.setSelectedItem(stepProcessorName);
                    bFound = true;
                }
                if (!bFound) {
                    this.m_stepProcessorComboBox.addItem(currentId);
                    this.m_stepProcessorComboBox.setSelectedItem(currentId);
                }
                if (this.m_authPropertyData.getSessionInfo().getDisplayConfigurationFunctionality() && (webAppTable = this.m_authPropertyData.getDesignerCoreData().getDataDictionary().getWebApplications()) != null && !webAppTable.isEmpty()) {
                    this.m_stepProcessorComboBox.addItem(new JSeparator());
                    this.m_stepProcessorComboBox.addItem(VWResource.s_registerANewStepProcessorDots);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        this.m_stepProcessorComboBox.addActionListener(this);
    }

    protected void handleDocumentEvent(DocumentEvent event) {
        if (this.m_stepDefinition == null) {
            return;
        }
        if (event.getDocument() == this.m_nameTextField.getDocument()) {
            this.updateName();
        } else if (event.getDocument() == this.m_instructionsTextArea.getDocument()) {
            this.m_stepDefinition.setDescription(this.m_instructionsTextArea.getText());
            this.m_authPropertyData.setDirty();
        }
    }

    protected void onStepProcessorComboBox() {
        block8: {
            try {
                String name = (String)this.m_stepProcessorComboBox.getSelectedItem();
                if (VWStringUtils.compare(name, VWResource.s_registerANewStepProcessorDots) == 0) {
                    VWStepProcessorRegistrationDialog dialog = this.getRegistrationDialog();
                    if (dialog != null) {
                        dialog.reinitialize();
                        dialog.show();
                        if (dialog.getExitStatus() == 0) {
                            name = dialog.getStepProcessorName();
                        }
                    }
                    if (VWStringUtils.compare(name, VWResource.s_registerANewStepProcessorDots) != 0) {
                        this.m_stepProcessorComboBox.removeActionListener(this);
                        this.m_stepProcessorComboBox.setSelectedItem(name);
                        this.m_stepProcessorComboBox.addActionListener(this);
                    } else {
                        this.m_stepProcessorComboBox.removeActionListener(this);
                        this.m_stepProcessorComboBox.setSelectedItem(this.m_stepDefinition.getRequestedInterface());
                        this.m_stepProcessorComboBox.addActionListener(this);
                        return;
                    }
                }
                if (this.m_stepProcessors == null) break block8;
                for (int i = 0; i < this.m_stepProcessors.length; ++i) {
                    if (VWStringUtils.compare(name, this.m_stepProcessors[i].getName()) != 0) continue;
                    this.m_stepDefinition.setRequestedInterface(this.m_stepProcessors[i].getName());
                    this.m_authPropertyData.setDirty();
                    break;
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
    }

    protected VWStepProcessorRegistrationDialog getRegistrationDialog() {
        if (this.m_stepProcessorRegistrationDialog == null) {
            this.m_stepProcessorRegistrationDialog = new VWStepProcessorRegistrationDialog(this.m_authPropertyData, 4);
        }
        return this.m_stepProcessorRegistrationDialog;
    }

    private void updateName() {
        try {
            if (this.m_stepDefinition != null && this.m_nameTextField != null) {
                String name = this.m_nameTextField.getText();
                String blankName = VWPropertyMenuItem.getBlankName(this.m_stepDefinition);
                if ((name.length() == 0 || name.equals(blankName)) && this.m_stepDefinition.getName() == null) {
                    return;
                }
                this.m_stepDefinition.setName(name);
                this.m_authPropertyData.setDirty();
                this.m_changedItems = new Vector();
                this.m_changedItems.addElement(this.m_stepDefinition);
                this.notifyPropertyChange();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

